<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Event;


use DateTime;
use JsonSerializable;
use Ramsey\Uuid\Uuid;
use Telemarcom\Bundle\MessageBundle\Enums\EventType;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

abstract class AbstractEvent extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;
    protected string $date;

    public function __construct()
    {
        parent::__construct();
        $this->type = EventType::DEFAULT;
        $date = new DateTime('now');
        $this->date = $date->format('c');
    }

    public function jsonSerialize(): array
    {
        return [
            'type' => $this->type,
            'uuid' => $this->uuid,
            'date' => $this->date,
            'data' => $this->data,
        ];
    }

    public function __toString(): string
    {
        return json_encode($this);
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function setUuid(string $uuid): void
    {
        $this->uuid = $uuid;
    }

    public function getData(): ?array
    {
        return $this->data;
    }

    public function setData($data): void
    {
        $this->data = $data;
    }

    public function getDate(): string
    {
        return $this->date;
    }

    public function setDate(string $date): void
    {
        $this->date = $date;
    }
}
