<?php

namespace Telemarcom\Bundle\MessageBundle\Message\Event\Webhook;

use Telemarcom\Bundle\MessageBundle\Enums\EventType;
use Telemarcom\Bundle\MessageBundle\Message\Event\AbstractEvent;

class AgentAcceptsCallEvent extends AbstractEvent
{
	public function __construct()
	{
		parent::__construct();
		$this->type = EventType::AGENT_ACCEPTS_CALL;
	}

	public function getUser(): ?string
	{
		return $this->data['user'];
	}

	public function setUser(?string $agentId): self
	{
		$this->data['user'] = $agentId;
		return $this;
	}

	public function getRelatedTickets(): ?array
	{
		return $this->data['relatedTickets'];
	}

	public function setRelatedTickets(?array $relatedTickets): self
	{
		$this->data['relatedTickets'] = $relatedTickets;
		return $this;
	}
}