<?php

namespace Telemarcom\Bundle\MessageBundle\Message\Skill;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class SkillIdentifiedByMailFromIncomingMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::SKILL_IDENTIFIED_BY_MAIL_FROM_INCOMING_MESSAGE;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(?string $mail): self
    {
        $this->data['mail'] = $mail;

        return $this;
    }

    public function getSkill(): ?string
    {
        return $this->data['skill'];
    }

    public function setSkill(?string $skill): self
    {
        $this->data['skill'] = $skill;

        return $this;
    }

    public function getProject(): ?string
    {
        return $this->data['project'];
    }

    public function setProject(?string $project): self
    {
        $this->data['project'] = $project;

        return $this;
    }

    public function getLanguage(): ?string
    {
        return $this->data['language'];
    }

    public function setLanguage(?string $language): self
    {
        $this->data['language'] = $language;

        return $this;
    }

    public function getCountry(): ?string
    {
        return $this->data['country'];
    }

    public function setCountry(?string $country): self
    {
        $this->data['country'] = $country;

        return $this;
    }
}