<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\User;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class UserLoggedInMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::USER_LOGGED_IN;
    }

    public function getUser(): string
    {
        return $this->data['user'];
    }

    public function setUser(string $user): self
    {
        $this->data['user'] = $user;
        return $this;
    }
}
