<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Ticket;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class TicketUpdatedFromUserMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::TICKET_UPDATED_FROM_USER;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }

    public function getUser(): ?string
    {
        return $this->data['user'];
    }

    public function setUser(string $mail): self
    {
        $this->data['user'] = $mail;

        return $this;
    }
}
