<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Ticket;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class TicketCreatedFromMailMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::TICKET_CREATED_FROM_MAIL;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(string $mail): self
    {
        $this->data['mail'] = $mail;

        return $this;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->data['phoneNumber'];
    }

    public function setPhoneNumber(string $phoneNumber): self
    {
        $this->data['phoneNumber'] = $phoneNumber;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->data['email'];
    }

    public function setEmail(string $email): self
    {
        $this->data['email'] = $email;

        return $this;
    }
}
