<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Webhook;

use DateTime;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class CallerOnHold extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::WEBHOOK_CALLER_ON_HOLD;
    }

    public function getCallId(): string
    {
        return $this->data['callId'];
    }

    public function setCallId(string $callId): self
    {
        $this->data['callId'] = $callId;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->data['datetime'];
    }

    public function setDatetime(DateTime $datetime): self
    {
        $this->data['datetime'] = $datetime;
        return $this;
    }

    public function getCountinQueueForSkill(): string
    {
        return $this->data['countinQueueForSkill'];
    }

    public function setCountinQueueForSkill(string $countinQueueForSkill): self
    {
        $this->data['countinQueueForSkill'] = $countinQueueForSkill;
        return $this;
    }

    public function getSkillId(): string
    {
        return $this->data['skillId'];
    }

    public function setSkillId(string $skillId): self
    {
        $this->data['skillId'] = $skillId;
        return $this;
    }

    public function getSkillName(): string
    {
        return $this->data['skillName'];
    }

    public function setSkillName(string $skillName): self
    {
        $this->data['skillName'] = $skillName;
        return $this;
    }

}
