<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Webhook;

use DateTime;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class OutdialCallingDest extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::WEBHOOK_OUTDIAL_CALLING_DEST;
    }

    public function getCallId(): string
    {
        return $this->data['callId'];
    }

    public function setCallId(string $callId): self
    {
        $this->data['callId'] = $callId;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->data['datetime'];
    }

    public function setDatetime(DateTime $datetime): self
    {
        $this->data['datetime'] = $datetime;
        return $this;
    }

    public function getDialedNumber(): string
    {
        return $this->data['dialedNumber'];
    }

    public function setDialedNumber(string $dialedNumber): self
    {
        $this->data['dialedNumber'] = $dialedNumber;
        return $this;
    }

    public function getOutdialClip(): string
    {
        return $this->data['outdialClip'];
    }

    public function setOutdialClip(string $outdialClip): self
    {
        $this->data['outdialClip'] = $outdialClip;
        return $this;
    }

    public function getCampgId(): string
    {
        return $this->data['campgId'];
    }

    public function setCampgId(string $campgId): self
    {
        $this->data['campgId'] = $campgId;
        return $this;
    }
}
