<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\User;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class UserRemovedFromTicketMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::USER_REMOVED_FROM_TICKET;
    }

    public function getUser(): string
    {
        return $this->data['user'];
    }

    public function setUser(string $user): self
    {
        $this->data['user'] = $user;

        return $this;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }
}
