<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Webhook;

use DateTime;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class IncomingCall extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::WEBHOOK_INCOMING_CALL;
    }

    public function getCallId(): string
    {
        return $this->data['callId'];
    }

    public function setCallId(string $callId): self
    {
        $this->data['callId'] = $callId;
        return $this;
    }

    public function getCgpn(): string
    {
        return $this->data['cgpn'];
    }

    public function setCgpn(string $cgpn): self
    {
        $this->data['cgpn'] = $cgpn;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->data['datetime'];
    }

    public function setDatetime(DateTime $datetime): self
    {
        $this->data['datetime'] = $datetime;
        return $this;
    }

    public function getCdpn(): string
    {
        return $this->data['cdpn'];
    }

    public function setCdpn(string $cdpn): self
    {
        $this->data['cdpn'] = $cdpn;
        return $this;
    }

}
