<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Mail;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class MailCreatedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::MAIL_CREATED;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(string $mail): self
    {
        $this->data['mail'] = $mail;

        return $this;
    }

    public function getProject(): ?string
    {
        return $this->data['project'];
    }

    public function setProject(string $project): self
    {
        $this->data['project'] = $project;

        return $this;
    }

    public function getSender(): ?string
    {
        return $this->data['sender'];
    }

    public function setSender(string $sender): self
    {
        $this->data['sender'] = $sender;

        return $this;
    }

    public function getDate(): ?string
    {
        return $this->data['date'];
    }

    public function setDate(string $date): self
    {
        $this->data['date'] = $date;

        return $this;
    }

    public function getRecipient(): ?string
    {
        return $this->data['recipient'];
    }

    public function setRecipient(string $recipient): self
    {
        $this->data['recipient'] = $recipient;

        return $this;
    }

    public function getSubject(): ?string
    {
        return $this->data['subject'];
    }

    public function setSubject(string $subject): self
    {
        $this->data['subject'] = $subject;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->data['message'];
    }

    public function setMessage(string $message): self
    {
        $this->data['message'] = $message;

        return $this;
    }

    public function getAttachments(): ?string
    {
        return $this->data['attachments'];
    }

    public function setAttachments(string $attachments): self
    {
        $this->data['attachments'] = $attachments;

        return $this;
    }

    public function getRaw(): ?string
    {
        return $this->data['raw'];
    }

    public function setRaw(string $raw): self
    {
        $this->data['raw'] = $raw;

        return $this;
    }

    public function getHtmlMessage(): ?string
    {
        return $this->data['html'];
    }

    public function setHtmlMessage(?string $html): self
    {
        $this->data['html'] = $html;

        return $this;
    }
}
