<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Enums;


class MessageType
{
    const DEFAULT = 'default';

    // Article
    const ARTICLE_CREATED = 'article-created';
    const ARTICLE_DELETED = 'article-deleted';
    const ARTICLE_ASSIGNED_TO_TICKET = 'article-assigned-to-ticket';

    // File
    const FILE_ASSIGNED_TO_MAIL = 'file-assigned-to-mail';
    const FILE_DELETED = 'file-deleted';
    const FILE_REMOVED_FROM_MAIL = 'file-removed-from-mail';
    const FILE_ATTACHED_TO_ARTICLE = 'file-attached-to-article';
    const FILE_DETACHED_FROM_ARTICLE = 'file-detached-from-article';
    const FILE_ATTACHED_TO_TICKET = 'file-attached-to-ticket';
    const FILE_DETACHED_FROM_TICKET = 'file-detached-from-ticket';

    // Mail
    const MAIL_CREATED = 'mail-created';
    const MAIL_DELETED = 'mail-deleted';
    const MAIL_QUALIFIED = 'mail-qualified';
    const MAIL_ASSIGNED_TO_TICKET = 'mail-assigned-to-ticket';
    const MAIL_REASSIGNED_TO_TICKET = 'mail-reassigned-to-ticket';
    const MAIL_REMOVED_FROM_TICKET = 'mail-removed-from-ticket';
    const MAIL_INCOMING = "mail-incoming";

    // Project
    const PROJECT_CREATED = 'project-created';
    const PROJECT_DELETED = 'project-deleted';
    const PROJECT_UPDATED = 'project-updated';
    const PROJECT_IDENTIFIED_BY_MAIL_FROM_TICKET = 'project-identified-by-mail-from-ticket';
    const PROJECT_IDENTIFIED_BY_PHONE_FROM_TICKET = 'project-identified-by-phone-from-ticket';
    const PROJECT_IDENTIFIED_BY_SKILL_FROM_TICKET = 'project-identified-by-skill-from-ticket';

    // Ticket
    const TICKET_CREATED = 'ticket-created';
    const TICKET_CREATED_FROM_CALL = 'ticket-created-from-call';
    const TICKET_CREATED_FROM_MAIL = 'ticket-created-from-mail';
    const TICKET_CREATED_FROM_USER = 'ticket-created-from-user';
    const TICKET_UPDATED = 'ticket-updated';
    const TICKET_UPDATED_FROM_CALL = 'ticket-updated-from-call';
    const TICKET_UPDATED_FROM_MAIL = 'ticket-updated-from-mail';
    const TICKET_UPDATED_FROM_USER = 'ticket-updated-from-user';
    const TICKET_DELETED = 'ticket-deleted';
    const TICKET_SOLVED = 'ticket-solved';
    const TICKET_REOPENED = 'ticket-reopened';
    const TICKET_ASSIGNED_TO_PROJECT = 'ticket-assigned-to-project';
    const TICKET_REMOVED_FROM_PROJECT = 'ticket-removed-from-project';

    // User
    const USER_CREATED = 'user-created';
    const USER_DELETED = 'user-deleted';
    const USER_UPDATED = 'user-updated';
    const USER_DISABLED = 'user-disabled';
    const USER_ENABLED = 'user-enabled';
    const USER_LOGGED_IN = 'user-logged-in';
    const USER_LOGGED_OUT = 'user-logged-out';
    const USER_ASSIGNED_TO_PROJECT = 'user-assigned-to-project';
    const USER_ASSIGNED_TO_TICKET = 'user-assigned-to-ticket';
    const USER_REMOVED_FROM_PROJECT = 'user-removed-from-project';
    const USER_REMOVED_FROM_TICKET = 'user-removed-from-ticket';

    // Webhook
    const WEBHOOK_INCOMING_CALL = 'webhook-incoming-call';
    const WEBHOOK_AGENT_ACCEPT_CALL = 'webhook-agent-accept-call';
    const WEBHOOK_CALLER_ON_HOLD = 'webhook-caller-on-hold';
    const WEBHOOK_CALLING_AGENT = 'webhook-calling-agent';
    const WEBHOOK_CANT_REACH_AGENT = 'webhook-cant-reach-agent';
    const WEBHOOK_CALL_ENDS = 'webhook-call-ends';
    const WEBHOOK_CALLER_HANGS_UP = 'webhook-caller-hangs-up';
    const WEBHOOK_OUTDIAL_CALLING_AGENT = 'webhook-outdial-calling-agent';
    const WEBHOOK_OUTDIAL_CALLING_DEST = 'webhook-outdial-calling-dest';
    const WEBHOOK_OUTDIAL_CANT_REACH_DEST = 'webhook-outdial-cant-reach-dest';
    const WEBHOOK_OUTDIAL_CALL_ENDS = 'webhook-outdial-call-ends';

}
