<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Webhook;

use DateTime;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class AgentAcceptsCall extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::WEBHOOK_AGENT_ACCEPT_CALL;
    }

    public function getCallId(): string
    {
        return $this->data['callId'];
    }

    public function setCallId(string $callId): self
    {
        $this->data['callId'] = $callId;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->data['datetime'];
    }

    public function setDatetime(DateTime $datetime): self
    {
        $this->data['datetime'] = $datetime;
        return $this;
    }

    public function getAgentId(): string
    {
        return $this->data['agentId'];
    }

    public function setAgentId(string $agentId): self
    {
        $this->data['agentId'] = $agentId;
        return $this;
    }

    public function getRingDuration(): int
    {
        return $this->data['ringDuration'];
    }

    public function setRingDuration(int $ringDuration): self
    {
        $this->data['ringDuration'] = $ringDuration;
        return $this;
    }

}
