<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Project;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class ProjectCreatedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::PROJECT_CREATED;
    }

    public function getProject(): ?string
    {
        return $this->data['project'];
    }

    public function setProject(string $project): self
    {
        $this->data['project'] = $project;
        return $this;
    }
}