<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Enums;


class MessageType
{
    const DEFAULT = 'default';

    // Article
    const ARTICLE_CREATED = 'article-created';
    const ARTICLE_DELETED = 'article-deleted';

    // Mail
    const MAIL_CREATED = 'mail-created';
    const MAIL_DELETED = 'mail-deleted';
    const MAIL_QUALIFIED = 'mail-qualified';
    const MAIL_ASSIGNED_TO_TICKET = 'mail-assigned-to-ticket';
    const MAIL_REMOVED_FROM_TICKET = 'mail-removed-from-ticket';
    const MAIL_INCOMING = "mail-incoming";

    // Project
    const PROJECT_CREATED = 'project-created';
    const PROJECT_DELETED = 'project-deleted';
    const PROJECT_UPDATED = 'project-updated';

    // Ticket
    const TICKET_CREATED = 'ticket-created';
    const TICKET_UPDATED = 'ticket-updated';
    const TICKET_DELETED = 'ticket-deleted';
    const TICKET_SOLVED = 'ticket-solved';
    const TICKET_REOPENED = 'ticket-reopened';
    const TICKET_ASSIGNED_TO_PROJECT = 'ticket-assigned_to_project';
    const TICKET_REMOVED_FROM_PROJECT = 'ticket-removed-from-project;';

    // User
    const USER_CREATED = 'user-created';
    const USER_DELETED = 'user-deleted';
    const USER_UPDATED = 'user-updated';
    const USER_DISABLED = 'user-disabled';
    const USER_ENABLED = 'user-enabled';
    const USER_LOGGED_IN = 'user-logged-in';
    const USER_LOGGED_OUT = 'user-logged-out';
    const USER_ASSIGNED_TO_PROJECT = 'user-assigned-to-project';
    const USER_REMOVED_FROM_PROJECT = 'user-removed-from-project';
}
