<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Mail;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class MailDeletedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::MAIL_DELETED;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(string $mail): self
    {
        $this->data['mail'] = $mail;
        return $this;
    }
}
