<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Mail;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class MailReassignedToTicketMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::MAIL_REASSIGNED_TO_TICKET;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(string $mail): self
    {
        $this->data['mail'] = $mail;
        return $this;
    }

    public function getSender(): ?string
    {
        return $this->data['sender'];
    }

    public function setSender(string $sender): self
    {
        $this->data['sender'] = $sender;
        return $this;
    }

    public function getSubject(): ?string
    {
        return $this->data['subject'];
    }

    public function setSubject(string $subject): self
    {
        $this->data['subject'] = $subject;
        return $this;
    }

    public function getOldTicket(): string
    {
        return $this->data['oldticket'];
    }

    public function setOldTicket(string $oldticket): self
    {
        $this->data['oldticket'] = $oldticket;
        return $this;
    }

    public function getNewTicket(): string
    {
        return $this->data['newticket'];
    }

    public function setNewTicket(string $newticket): self
    {
        $this->data['newticket'] = $newticket;
        return $this;
    }

    public function getMailType(): ?string
    {
        return $this->data['mailtype'];
    }

    public function setMailType(string $mailtype): self
    {
        $this->data['mailtype'] = $mailtype;
        return $this;
    }

    public function getAdditionalInfo(): ?string
    {
        return $this->data['additionalInfo'];
    }

    public function setAdditionalInfo(string $additionalInfo): self
    {
        $this->data['additionalInfo'] = $additionalInfo;
        return $this;
    }
}
