<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Webhook;

use DateTime;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class CallerHangsUp extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::WEBHOOK_CALLER_HANGS_UP;
    }

    public function getCallId(): string
    {
        return $this->data['callId'];
    }

    public function setCallId(string $callId): self
    {
        $this->data['callId'] = $callId;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->data['datetime'];
    }

    public function setDatetime(DateTime $datetime): self
    {
        $this->data['datetime'] = $datetime;
        return $this;
    }
    
}
