<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message;


use JsonSerializable;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Ramsey\Uuid\Uuid;

abstract class AbstractMessage implements JsonSerializable
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        $this->type = MessageType::DEFAULT;
        $this->uuid = Uuid::uuid4()->toString();
        $this->data = [];
    }

    public function jsonSerialize()
    {
        return [
            'type' => $this->type,
            'uuid' => $this->uuid,
            'data' => $this->data,
        ];
    }

    public function __toString(): string
    {
        return json_encode($this);
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function setUuid(string $uuid): void
    {
        $this->uuid = $uuid;
    }

    public function getData()
    {
        return $this->data;
    }

    public function setData($data): void
    {
        $this->data = $data;
    }
}
