<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Project;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class ProjectIdentifiedBySkillFromTicketMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::PROJECT_IDENTIFIED_BY_SKILL_FROM_TICKET;
    }

    public function getProject(): ?string
    {
        return $this->data['project'];
    }

    public function setProject(string $project): self
    {
        $this->data['project'] = $project;

        return $this;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }
}
