<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\User;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class UserRemovedFromProjectMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::USER_REMOVED_FROM_PROJECT;
    }

    public function getUser(): string
    {
        return $this->data['user'];
    }

    public function setUser(string $user): self
    {
        $this->data['user'] = $user;
        return $this;
    }

    public function getProject(string $project): string
    {
        return $this->data['project'];
    }

    public function setProject(string $project): self
    {
        $this->data['project'] = $project;
        return $this;
    }
}
