<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Article;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class ArticleAssignedToTicketMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::ARTICLE_ASSIGNED_TO_TICKET;
    }

    public function getArticle(): ?string
    {
        return $this->data['article'];
    }

    public function setArticle(?string $article): self
    {
        $this->data['article'] = $article;
        return $this;
    }

    public function getTicket(): string
    {
        return $this->data['ticket'];
    }

    public function setTicket(string $ticket): self
    {
        $this->data['ticket'] = $ticket;
        return $this;
    }
}
