<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Article;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class ArticleCreatedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::ARTICLE_CREATED;
    }

    public function getArticle(): string
    {
        return $this->data['article'];
    }

    public function setArticle(string $article): self
    {
        $this->data['article'] = $article;
        return $this;
    }
}
