<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Webhook;

use DateTime;
use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class OutdialCantReachDest extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::WEBHOOK_OUTDIAL_CANT_REACH_DEST;
    }

    public function getCallId(): string
    {
        return $this->data['callId'];
    }

    public function setCallId(string $callId): self
    {
        $this->data['callId'] = $callId;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->data['datetime'];
    }

    public function setDatetime(DateTime $datetime): self
    {
        $this->data['datetime'] = $datetime;
        return $this;
    }

    public function getReason(): string
    {
        return $this->data['reason'];
    }

    public function setReason(string $reason): self
    {
        $this->data['reason'] = $reason;
        return $this;
    }

    public function getRingDuration(): string
    {
        return $this->data['ringDuration'];
    }

    public function setRingDuration(string $ringDuration): self
    {
        $this->data['ringDuration'] = $ringDuration;
        return $this;
    }
}
