<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Ticket;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class TicketAssignedToProjectMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::TICKET_ASSIGNED_TO_PROJECT;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(?string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }

    public function getProject(): ?string
    {
        return $this->data['project'];
    }

    public function setProject(?string $project): self
    {
        $this->data['project'] = $project;

        return $this;
    }
}
