<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Event\User;

use Telemarcom\Bundle\MessageBundle\Enums\EventType;
use Telemarcom\Bundle\MessageBundle\Message\Event\AbstractEvent;

class UserMentionedInTicketMessage extends AbstractEvent
{
    public function __construct()
    {
        parent::__construct();
        $this->type = EventType::USER_MENTIONED_IN_TICKET;
    }

    public function getUser(): ?array
    {
        return $this->data['user'];
    }

    public function setUser(?string $uuid): self
    {
        $this->data['user'] = $uuid;
        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->data['message'];
    }

    public function setMessage(?string $message): self
    {
        $this->data['message'] = $message;
        return $this;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(?string $ticket): self
    {
        $this->data['ticket'] = $ticket;
        return $this;
    }
}
