<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\File;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class FileAssignedToMailMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::FILE_ASSIGNED_TO_MAIL;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(?string $mail): self
    {
        $this->data['mail'] = $mail;

        return $this;
    }

    public function getFile(): string
    {
        return $this->data['file'];
    }

    public function setFile(string $file): self
    {
        $this->data['file'] = $file;

        return $this;
    }
}
