<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\File;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class FileAttachedToTicketMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::FILE_ATTACHED_TO_TICKET;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(?string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }

    public function getFile(): string
    {
        return $this->data['file'];
    }

    public function setFile(string $file): self
    {
        $this->data['file'] = $file;

        return $this;
    }
}
