<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\File;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class FileDeletedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::FILE_DELETED;
    }

    public function getFile(): ?string
    {
        return $this->data['file'];
    }

    public function setFile(?string $file): self
    {
        $this->data['file'] = $file;
        return $this;
    }
}
