<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Mail;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class MailDeletedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::MAIL_DELETED;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(?string $mail): self
    {
        $this->data['mail'] = $mail;

        return $this;
    }

    public function getAttachments(): ?array
    {
        return $this->data['attachments'];
    }

    public function setAttachments(?array $attachments): self
    {
        $this->data['attachments'] = $attachments;

        return $this;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(?string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }
}
