<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Ticket;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class TicketRemovedFromSkillMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::TICKET_REMOVED_FROM_SKILL;
    }

    public function getTicket(): ?string
    {
        return $this->data['ticket'];
    }

    public function setTicket(?string $ticket): self
    {
        $this->data['ticket'] = $ticket;

        return $this;
    }

    public function getSkill(): ?string
    {
        return $this->data['skill'];
    }

    public function setSkill(?string $skill): self
    {
        $this->data['skill'] = $skill;

        return $this;
    }
}
