<?php

declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Mail;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class MailIncomingMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::MAIL_INCOMING;
    }

    public function getMail(): ?string
    {
        return $this->data['mail'];
    }

    public function setMail(?string $mail): self
    {
        $this->data['mail'] = $mail;

        return $this;
    }

    public function getSender(): ?string
    {
        return $this->data['sender'];
    }

    public function setSender(?string $sender): self
    {
        $this->data['sender'] = $sender;

        return $this;
    }

    public function getSubject(): ?string
    {
        return $this->data['subject'];
    }

    public function setSubject(?string $subject): self
    {
        $this->data['subject'] = $subject;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->data['message'];
    }

    public function setMessage(?string $message): self
    {
        $this->data['message'] = $message;

        return $this;
    }

    public function getAttachments(): ?string
    {
        return $this->data['attachments'];
    }

    public function setAttachments(?string $attachments): self
    {
        $this->data['attachments'] = $attachments;

        return $this;
    }

    public function getRecipients(): ?array
    {
        return $this->data['recipients'];
    }

    public function setRecipients(?array $recipients): self
    {
        $this->data['recipients'] = $recipients;
        return $this;
    }
}
