<?php
declare(strict_types=1);

namespace Telemarcom\Bundle\MessageBundle\Message\Skill;

use Telemarcom\Bundle\MessageBundle\Enums\MessageType;
use Telemarcom\Bundle\MessageBundle\Message\AbstractMessage;

class SkillDeletedMessage extends AbstractMessage
{
    protected string $type;
    protected string $uuid;
    protected array $data;

    public function __construct()
    {
        parent::__construct();
        $this->type = MessageType::SKILL_DELETED;
    }

    public function getSkill(): ?string
    {
        return $this->data['skill'];
    }

    public function setSkill(?string $skill): self
    {
        $this->data['skill'] = $skill;
        return $this;
    }
}